SELECT users.record_list_name as utente,
       vehicles.record_list_name as veicolo,
       doc.record_linked_table as tipologia,
       doc.record_linked_id,
       doc.record_typology,
       doc.record_sub_typology as sub_tipologia,
       doc.record_list_name as nome,
       doc.document_name as documento,
       doc.document_text as info,
       doc.issued_by as emesso_da,
       doc.start_at as inizio_validita,
       doc.end_at as fine_validita,
#        doc.alert_from_days  ,
#        doc.alert_at,
#        doc.file_name1 as file,
#        doc.file_description1,
#        doc.file_name2,
#        doc.file_description2,
#        doc.file_name3,
#        doc.file_description3,
#        doc.file_name4,
#        doc.file_description4,
#        doc.burocrazia,
       doc.record_extras as extra
FROM documents as doc
   left join users on doc.record_linked_id=users.user_id and doc.record_linked_table = 'employees'
   left join vehicles on doc.record_linked_id=vehicles.vehicle_id and doc.record_linked_table = 'vehicles'
WHERE doc.alert_at <> 'NULL'
  AND doc.alert_at
    BETWEEN CURDATE() and DATE_ADD(NOW(), INTERVAL 15 DAY )
 or doc.end_at BETWEEN CURDATE() and DATE_ADD(NOW(), INTERVAL 15 DAY )
or doc.end_at BETWEEN CURDATE() and doc.alert_at
ORDER BY doc.record_typology, doc.end_at,doc.alert_at ASC